<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo e($page_title); ?> </h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taskmanager_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.taskmanager.create')); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('quickadmin.qa_add_new'); ?></a>
        
    </p>
    <?php endif; ?>

	
		<div class="row">
<div class="col-xs-12 form-group">

    <?php echo Form::open(['method' => 'POST', 'route' => ['admin.reports.task']]); ?>


    <div class="panel panel-default">
     
        
        <div class="panel-body">
       
			
		     <div class="row">
                <div class="col-xs-12 form-group"> 
				<?php echo Form::label('owner_id', 'Owner', ['class' => 'control-label']); ?>

				
				
				<?php echo Form::select('owner_id', $owner, old('owner_id'), ['class' => 'form-control select2']); ?>

			</div>
          </div>
			
			
            <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('employee_id', 'Employee*', ['class' => 'control-label']); ?>

						<?php echo Form::select('employee_id', $employees, old('employee_id'), ['class' => 'form-control select2']); ?>

                </div>
            </div>
			

            			
			<div class="row">
                <div class="col-xs-12 form-group"> 
				<?php echo Form::label('progress_status', 'Job Status', ['class' => 'control-label']); ?>

				
					<?php echo Form::select('progress_status', $status, old('progress_status'), ['class' => 'form-control select2']); ?>

			</div>
          </div>
      
			
			
	
            
        </div>
    </div>

    <?php echo Form::submit('Search', ['class' => 'btn btn-danger']); ?>

    <?php echo Form::close(); ?>

</div>
</div>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('quickadmin.qa_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped <?php echo e(count($tasks) > 0 ? 'datatable' : ''); ?> <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taskmanager_delete')): ?> dt-select <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taskmanager_delete')): ?>
                            <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        <?php endif; ?>

                        <th>Company</th>
                        <th>Owner</th>
                        <th>Segment</th>
						<th>Employee</th>
						
						  <th> Meeting</th>
                        <th>Meeting Date</th>
                        <th>Deadline</th>
						<th>Review Date</th>
						
                        <th>Status</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                
                <tbody>
                    <?php if(count($tasks) > 0): ?>
                        <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-entry-id="<?php echo e($task->id); ?>">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taskmanager_delete')): ?>
                                    <td></td>
                                <?php endif; ?>

                                <td><?php echo e($task->company_id); ?> </td>
                                <td><?php echo e($task->owner_id); ?></td>
                                
                                <td><?php echo e($task->segment_id); ?></td>
								<td><?php echo e($task->employee_id); ?></td>
								
								<td><?php echo e($task->type_of_meeting); ?> </td>
                                <td><?php echo e($task->meeting_date); ?></td>
                                
                                <td><?php echo e($task->deadline); ?></td>
								<td><?php echo e($task->review_date); ?></td>
								
								
								
								
								<?php if($task->progress_status == 'Completed' && 
								 $task->approved ==1): ?>
								<td style="background:green"><?php echo e($task->progress_status); ?>

								
								<br>
									<a href="<?php echo e(url('admin/task/status/'.$task->id)); ?>" 
								 class="btn btn-xs btn-primary"> Remarks </a>
								</td>
								
								 <?php elseif($task->progress_status == 'Completed' && 
								 $task->approved !=1): ?>
								<td style="background:red"><?php echo e($task->progress_status); ?>

								<br>
									<a href="<?php echo e(url('admin/task/status/'.$task->id)); ?>" 
								 class="btn btn-xs btn-primary"> Remarks </a>
								</td>
								<?php else: ?> 
								<td><?php echo e($task->progress_status); ?>

							<br>
									<a href="<?php echo e(url('admin/task/status/'.$task->id)); ?>" 
								 class="btn btn-xs btn-primary"> Remarks </a>
							</td>	
								<?php endif; ?>
								
								
                                <td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taskmanager_view')): ?>
                                    <a href="<?php echo e(route('admin.taskmanager.show',[$task->id])); ?>" class="btn btn-xs btn-primary"><?php echo app('translator')->getFromJson('quickadmin.qa_view'); ?></a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taskmanager_edit')): ?>
                                    <a href="<?php echo e(route('admin.taskmanager.edit',[$task->id])); ?>" class="btn btn-xs btn-info"><?php echo app('translator')->getFromJson('quickadmin.qa_edit'); ?></a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taskmanager_delete')): ?>
                                    <?php echo Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("quickadmin.qa_are_you_sure")."');",
                                        'route' => ['admin.taskmanager.destroy', $task->id])); ?>

                                    <?php echo Form::submit(trans('quickadmin.qa_delete'), array('class' => 'btn btn-xs btn-danger')); ?>

                                    <?php echo Form::close(); ?>

                                    <?php endif; ?>
									 <?php if($task->progress_status == 'Completed'): ?>
									<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taskmanager_approve')): ?>
                                    <?php echo Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("Are you sure to approve")."');",
                                        'route' => ['admin.task_import.destroy', $task->id])); ?>

                                    <?php echo Form::submit(trans('Approve'), array('class' => 'btn btn-xs btn-danger')); ?>

                                    <?php echo Form::close(); ?>

                                    <?php endif; ?>
									<?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8"><?php echo app('translator')->getFromJson('quickadmin.qa_no_entries_in_table'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('owner_delete')): ?>
            window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.taskmanager.mass_destroy')); ?>';
        <?php endif; ?>

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>