<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('quickadmin.appointments.title'); ?></h3>
    <?php echo Form::open(['method' => 'POST', 'route' => ['admin.working_hours.store']]); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('quickadmin.qa_create'); ?>
        </div>
        
        <div class="panel-body">
            <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('owner_id', 'Owner *', ['class' => 'control-label']); ?>

					<select name="owner_id" id="owner_id" value="<?php echo e(old('owner_id')); ?>" class="form-control" required>
						<option value="">Please select</option>
						<?php $__currentLoopData = $owners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($owner->id); ?>"><?php echo e($owner->name); ?> </option>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</select>
                    <p class="help-block"></p>
                    <?php if($errors->has('owner_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('owner_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('date', 'Date*', ['class' => 'control-label']); ?>

                    <?php echo Form::text('date', old('date'), ['class' => 'form-control date', 'placeholder' => '', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('date')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('date')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('start_time', 'Start time*', ['class' => 'control-label']); ?>

                    <?php echo Form::text('start_time', old('start_time'), ['class' => 'form-control timepicker', 'placeholder' => '', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('start_time')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('start_time')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('finish_time', 'Finish time', ['class' => 'control-label']); ?>

                    <?php echo Form::text('finish_time', old('finish_time'), ['class' => 'form-control timepicker', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('finish_time')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('finish_time')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
		<div class="row">
                <div class="col-xs-12 form-group">
                    <?php echo Form::label('task_name', 'Task', ['class' => 'control-label']); ?>

                    <?php echo Form::text('task_name', old('task_name'), ['class' => 'form-control', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('task_name')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('task_name')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>	
			
		<div class="row">
                <div class="col-xs-12 form-group"> 
				<?php echo Form::label('status', 'Meeting Status', ['class' => 'control-label']); ?>

				
				
				<select name="status" id="status" value="<?php echo e(old('status')); ?>" class="form-control" required>
						<option value="">Please select</option>
			<?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<option value="<?php echo e($stas->name); ?>">
			<?php echo e($stas->name); ?>

			</option>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			  </select>
			</div>
          </div>
		  
		  
		  

		  
		  
		   <div class="row">
                <div class="col-xs-12 form-group"> 
				<?php echo Form::label('remarks', 'Remarks', ['class' => 'control-label']); ?>

				
				
				<textarea name="remarks" id="remarks"  class="form-control" >
				<?php echo e(old('remarks')); ?>

			  </textarea>
			</div>
          </div>
			
			
			
            
        </div>
    </div>

    <?php echo Form::submit(trans('quickadmin.qa_save'), ['class' => 'btn btn-danger']); ?>

    <?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##
    <script>
        $('.date').datepicker({
            autoclose: true,
            dateFormat: "<?php echo e(config('app.date_format_js')); ?>"
        });
    </script>
    <script src="<?php echo e(url('quickadmin/js')); ?>/timepicker.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.4.5/jquery-ui-timepicker-addon.min.js"></script>
    <script src="https://cdn.datatables.net/select/1.2.0/js/dataTables.select.min.js"></script>    <script>
        $('.timepicker').datetimepicker({
            autoclose: true,
            timeFormat: "HH:mm:ss",
            timeOnly: true
        });
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>