<?php
Route::get('/', function () { return redirect('/admin/home'); });

// Authentication Routes...
$this->get('login', 'Auth\LoginController@showLoginForm')->name('auth.login');
$this->post('login', 'Auth\LoginController@login')->name('auth.login');
$this->post('logout', 'Auth\LoginController@logout')->name('auth.logout');

// Change Password Routes...
$this->get('change_password', 'Auth\ChangePasswordController@showChangePasswordForm')->name('auth.change_password');
$this->patch('change_password', 'Auth\ChangePasswordController@changePassword')->name('auth.change_password');

// Password Reset Routes...
$this->get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('auth.password.reset');
$this->post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('auth.password.reset');
$this->get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
$this->post('password/reset', 'Auth\ResetPasswordController@reset')->name('auth.password.reset');

Route::group(['middleware' => ['auth'], 'prefix' => 'admin', 'as' => 'admin.'], function () {
    Route::get('/home', 'HomeController@index');
    Route::resource('roles', 'Admin\RolesController');
    Route::post('roles_mass_destroy', ['uses' => 'Admin\RolesController@massDestroy', 'as' => 'roles.mass_destroy']);
    Route::resource('users', 'Admin\UsersController');
	
	
	//Route::post('/reports/searchlist', 'Admin\ReportsController@index');
	
	
	  Route::post('searchlist', ['uses' => 'Admin\ReportsController@index', 'as' => 'reports.index']);
	  
	  Route::post('task/reports', ['uses' => 'Admin\ReportsController@task', 'as' => 'reports.task']);
	  
	  
	 
	//Route::get('/task/weekly_pending', 'Admin\WorkingHoursController@taskweekly_pending');
	
	
	
    Route::post('users_mass_destroy', ['uses' => 'Admin\UsersController@massDestroy', 'as' => 'users.mass_destroy']);
    Route::resource('clients', 'Admin\ClientsController');
    Route::post('clients_mass_destroy', ['uses' => 'Admin\ClientsController@massDestroy', 'as' => 'clients.mass_destroy']);
	Route::get('get-employees', 'Admin\EmployeesController@GetEmployees');
    Route::resource('employees', 'Admin\EmployeesController');
    Route::post('employees_mass_destroy', ['uses' => 'Admin\EmployeesController@massDestroy', 'as' => 'employees.mass_destroy']);
    Route::resource('working_hours', 'Admin\WorkingHoursController');
    Route::post('working_hours_mass_destroy', ['uses' => 'Admin\WorkingHoursController@massDestroy', 'as' => 'working_hours.mass_destroy']);
    Route::resource('appointments', 'Admin\AppointmentsController');
	
	Route::resource('taskmanager', 'Admin\TaskmanagerController');
	
	
	Route::post('taskmanager_mass_destroy', ['uses' => 'Admin\TaskmanagerController@massDestroy', 'as' => 'taskmanager.mass_destroy']);
	
	
	
	Route::resource('task_import', 'Admin\Task_importController');
	
	//Route::resource('task_import.store', 'Admin\Task_importController@store');
	
	Route::post('/task_import/import', 'Admin\Task_importController@import');
	 
	//Route::get('taskmanager', 'Admin\AppointmentsController@taskmanager');
	
	//Route::get('/task', 'Admin\TaskController@index');
	
	 //Route::get('taskmanager', ['uses' => 'Admin\AppointmentsController@massDestroy', 'as' => 'appointments.taskmanager']);
	 
	 
	 Route::resource('appointments.task_import', 'Admin\AppointmentsController@task_import');
	 
    Route::post('appointments_mass_destroy', ['uses' => 'Admin\AppointmentsController@massDestroy', 'as' => 'appointments.mass_destroy']);
	Route::resource('services', 'Admin\ServicesController');
	Route::post('services_mass_destroy', ['uses' => 'Admin\ServicesController@massDestroy', 'as' => 'services.mass_destroy']);
	
	Route::resource('company', 'Admin\CompanyController');
    Route::post('company_mass_destroy', ['uses' => 'Admin\CompanyController@massDestroy', 'as' => 'company.mass_destroy']);
	
	
	Route::resource('owners', 'Admin\OwnersController');
    Route::post('owners_mass_destroy', ['uses' => 'Admin\OwnersController@massDestroy', 'as' => 'owners.mass_destroy']);
	
	/*dashboard links */
	
	Route::get('/appointment/today', 'Admin\WorkingHoursController@appointment_today');
	
	Route::get('/appointment/today_pending', 'Admin\WorkingHoursController@appointment_todaypendding');
	
	Route::get('/appointment/today_completed', 'Admin\WorkingHoursController@appointment_todaycompleted');
	
//	Route::get('/taskmanager/status', 'Admin\TaskmanagerController@statusdetails');
	
	
	// Task ReportsController@index
	
	Route::get('/task/status/{id}', 'Admin\WorkingHoursController@task_status');
	
	Route::get('/task/reports', 'Admin\WorkingHoursController@task_reports');
	
	Route::get('/task/approve', 'Admin\WorkingHoursController@task_approve');
	
	
	Route::get('/task/today', 'Admin\WorkingHoursController@task_today');
	
	Route::get('/task/today_pending', 'Admin\WorkingHoursController@task_todaypending');
	
	Route::get('/task/today_completed', 'Admin\WorkingHoursController@task_todaycompleted');
	
	
	Route::get('/task/weekly_task', 'Admin\WorkingHoursController@weekly_task');
	
	Route::get('/task/weekly_pending', 'Admin\WorkingHoursController@taskweekly_pending');
	
	Route::get('/task/weekly_completed', 'Admin\WorkingHoursController@taskweekly_completed');
	
	
	Route::get('/appointment/weekly', 'Admin\WorkingHoursController@appointment_weekly');
	
	Route::get('/appointment/lask_weekly', 'Admin\WorkingHoursController@appointment_lastweekly');
	
	Route::get('/appointment/weekly_total', 'Admin\WorkingHoursController@appointment_total');
	
	
	
	
});
