@extends('layouts.app')

@section('content')
    <h3 class="page-title">Appointments </h3>
    @can('working_hour_create')
    <p>
        <a href="{{ route('admin.working_hours.create') }}" class="btn btn-success">@lang('quickadmin.qa_add_new')</a>
        
    </p>
    @endcan

    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.css' />

	<style>
	.fc-time-grid-event.fc-short .fc-time span {
    display: inline;
}

.fc-time-grid-event.fc-short .fc-time:before {
    content: normal;
}  

.fc-time-grid-event.fc-short .fc-time:after {
    content: normal;
}
</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/qtip2/3.0.3/jquery.qtip.css" rel="stylesheet"/>
    <div id='calendar'></div>

@stop

@section('javascript')
    <script src='https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.17.1/moment.min.js'></script>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.js'></script>
   

<script src="https://cdnjs.cloudflare.com/ajax/libs/qtip2/3.0.3/jquery.qtip.js"></script>



   <script>
        $(document).ready(function() {
            // page is now ready, initialize the calendar...
            $('#calendar').fullCalendar({
                // put your options and callbacks here
               // defaultView: 'agendaWeek',
			   //timeFormat: 'HH:mm { - HH:mm}',

                events : [
                    @foreach($working_hours as $hour)
                    {
                        title : '{{ $hour->name  }}',
                        start : '{{ $hour->date . ' ' . $hour->start_time }}',
                        end : '{{ $hour->date . ' ' . $hour->finish_time }}',
                        url : '{{ route('admin.working_hours.edit', $hour->id) }}'
                    },
                    @endforeach
                ],
				
				  eventRender: function(event, element) {
					  
    element.qtip({
      content: 	'<b>' + event.start.format('hh:mma') + ' - ' + event.end.format('hh:mma') + '</b>' +
        	'<br>' +
        	'<u>' + event.title + '</u>'
    });
  }

            })
        });
    </script>
@endsection