@extends('layouts.app')

@section('content')
    <h3 class="page-title">Task Manager</h3>
	
	
	
	    <div class="panel panel-default">
        <div class="panel-heading">
            Remarks History
        </div>

        <div class="panel-body">
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-bordered table-striped" cellpadding="10">
                      		
            
                <thead>
                    <tr>
                        
                        
                        <th> S.No </th>
						<th>Task Name</th>
                        <th>Changes From</th>
                        <th>Changes</th>
                        <th>Date</th>
                       
                        
                    </tr>
                </thead>
                
                <tbody>
                    @if (count($task_history) > 0)
						@php($count=0)


                        @foreach ($task_history as $history)
						@php($count++)

                            <tr >
                                
                                <td>{{$count}}</td>
								<td>{{$history->item}}</td>
                                <td  style="text-transform: capitalize;">
								@if ($history->change_type == 'progress_status')
								{{ 'Status' }}
							    @else
								{{ $history->change_type}}
							   @endif
							</td>
                                <td>{{ $history->change_value }}</td>
                                
                                <td>{{ $history->created_on }}</td>

                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="8">@lang('quickadmin.qa_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
			
			
	
                </div>
            </div>

            <p>&nbsp;</p>

            <a href="{{ url('admin/task/reports') }}" class="btn btn-default">@lang('quickadmin.qa_back_to_list')</a>
			 
        </div>
    </div>
	
  
@stop

@section('javascript')
    @parent
    <script>
        $('.date').datepicker({
            autoclose: true,
            dateFormat: "{{ config('app.date_format_js') }}"
        });
    </script>
    <script src="{{ url('quickadmin/js') }}/timepicker.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.4.5/jquery-ui-timepicker-addon.min.js"></script>
    <script src="https://cdn.datatables.net/select/1.2.0/js/dataTables.select.min.js"></script>    <script>
        $('.timepicker').datetimepicker({
            autoclose: true,
            timeFormat: "HH:mm:ss",
            timeOnly: true
        });
    </script>

@stop