@extends('layouts.app')

@section('content')
    <h3 class="page-title">Task Manager</h3>
    <div class="row">
	<div class="col-xs-11">
    {!! Form::model($taskmanager, ['method' => 'PUT', 'route' => ['admin.taskmanager.update', $taskmanager->id]]) !!}
    
	
    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_edit')
        </div>

        <div class="panel-body">
            <div class="row">
			 
                <div class="col-xs-12 form-group"> 
				{!! Form::label('company_id', 'Company', ['class' => 'control-label']) !!}
				
				
			
			  
			  {!! Form::select('company_id', $company, old('company_id'), ['class' => 'form-control select2', 'required' => '']) !!}
			  
			  
			</div>
          </div>
		  
		  
		   <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('item', 'Item', ['class' => 'control-label']) !!}
				
				
				<textarea name="item" id="item"  class="form-control" required>
				{{ old('item') }} {{ $taskmanager->item }}
			  </textarea>
			</div>
          </div>
		  
		  
	        <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('segment_id', 'Segment', ['class' => 'control-label']) !!}
				
				
				{!! Form::select('segment_id', $segments, old('segment_id'), ['class' => 'form-control select2', 'required' => '']) !!}
			  
			</div>
          </div>
		  
		  
		  
		     <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('owner_id', 'Owner', ['class' => 'control-label']) !!}
				
				
				
				{!! Form::select('owner_id', $owner, old('owner_id'), ['class' => 'form-control select2', 'required' => '']) !!}
			</div>
          </div>
			
			
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('employee_id', 'Employee*', ['class' => 'control-label']) !!}
					{!! Form::select('employee_id', $employees, old('employee_id'), ['class' => 'form-control select2', 'required' => '']) !!}
                </div>
            </div>
			
			
			
			<div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('type_of_meeting', 'Type of Meeting', ['class' => 'control-label']) !!}
				
				
				{!! Form::select('type_of_meeting', $meeting, old('type_of_meeting'), ['class' => 'form-control select2', 'required' => '']) !!}
			</div>
          </div>
		  
		  
		  
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('meeting_date', 'Meeting Date*', ['class' => 'control-label']) !!}
                    {!! Form::text('meeting_date', old('meeting_date'), ['class' => 'form-control date', 'placeholder' => '', 'required' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('meeting_date'))
                        <p class="help-block">
                            {{ $errors->first('meeting_date') }}
                        </p>
                    @endif
                </div>
            </div>
			
			
			 <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('deadline', 'Deadline Date*', ['class' => 'control-label']) !!}
                    {!! Form::text('deadline', old('deadline'), ['class' => 'form-control date', 'placeholder' => '', 'required' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('deadline'))
                        <p class="help-block">
                            {{ $errors->first('deadline') }}
                        </p>
                    @endif
                </div>
            </div>
			
			
			
			 <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('review_date', 'Review Date*', ['class' => 'control-label']) !!}
                    {!! Form::text('review_date', old('review_date'), ['class' => 'form-control date', 'placeholder' => '', 'required' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('review_date'))
                        <p class="help-block">
                            {{ $errors->first('review_date') }}
                        </p>
                    @endif
                </div>
            </div>
			
			
			<div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('progress_status', 'Job Status', ['class' => 'control-label']) !!}
				
				
				{!! Form::select('progress_status', $status, old('progress_status'), ['class' => 'form-control select2', 'required' => '']) !!}
			  
			</div>
          </div>
		  
		  
		  

		  
		  
		   <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('remarks', 'Remarks', ['class' => 'control-label']) !!}
				
				
				<textarea name="remarks" id="remarks"  class="form-control" >
				{{ old('remarks') }}  {{ $taskmanager->remarks }}
			  </textarea>
			</div>
          </div>
		  
		  
		  
		 <div class="row">
                <div class="col-xs-12 form-group"> 
			
				
				<input type="checkbox" value="{{ old('reminder') }}" name="reminder" id="reminder"   >
				Reminder
			
			 
			</div>
          </div>
		  
		  
		    <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('email', 'Reminder Email', ['class' => 'control-label']) !!}
				
				
				<input type="text"  name="email"  value="{{ old('email') }} {{ $taskmanager->email }}" id="email"  class="form-control" >
				
			
			</div>
          </div>
		  
		  
		  <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('email_cc', 'Reminder CC', ['class' => 'control-label']) !!}
				
				
				<input type="text"  name="email_cc"  value="{{ old('email_cc') }} {{ $taskmanager->email_cc }}" id="email_cc"  class="form-control" >
				
			
			</div>
          </div>
		  
		</div>  
		
		
		


    {!! Form::submit(trans('quickadmin.qa_update'), ['class' => 'btn btn-danger']) !!}
    {!! Form::close() !!}
				
    </div>
	</div>
	
   
   </div>
   
@stop

@section('javascript')
    @parent
    <script>
        $('.date').datepicker({
            autoclose: true,
            dateFormat: "{{ config('app.date_format_js') }}"
        });
    </script>
    <script src="{{ url('quickadmin/js') }}/timepicker.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.4.5/jquery-ui-timepicker-addon.min.js"></script>
    <script src="https://cdn.datatables.net/select/1.2.0/js/dataTables.select.min.js"></script>    <script>
        $('.timepicker').datetimepicker({
            autoclose: true,
            timeFormat: "HH:mm:ss",
            timeOnly: true
        });
    </script>

@stop