@extends('layouts.app')

@section('content')
    <h3 class="page-title">Task Manager</h3>
    {!! Form::open(['method' => 'POST', 'route' => ['admin.taskmanager.store']]) !!}

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_create')
        </div>
        
        <div class="panel-body">
		
		
		 <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('company_id', 'Company', ['class' => 'control-label']) !!}
				
				
				<select name="company_id" id="company_id" value="{{ old('company_id') }}" class="form-control" required>
						<option value="">Please select</option>
			@foreach($company as $comp)
			<option value="{{$comp->company_name}}">
			{{ $comp->company_name }}
			</option>
			@endforeach
			  </select>
			</div>
          </div>
		  
		  
		   <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('item', 'Item', ['class' => 'control-label']) !!}
				
				
				<textarea name="item" id="item"  class="form-control" required>
				{{ old('item') }}
			  </textarea>
			</div>
          </div>
		  
		  
	        <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('segment_id', 'Segment', ['class' => 'control-label']) !!}
				
				
				<select name="segment_id" id="segment_id" value="{{ old('segment_id') }}" class="form-control" required>
						<option value="">Please select</option>
			@foreach($segments as $segment)
			<option value="{{ $segment->segment_name }}">
			{{ $segment->segment_name }}
			</option>
			@endforeach
			  </select>
			</div>
          </div>
		  
		  
		  
		     <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('owner_id', 'Owner', ['class' => 'control-label']) !!}
				
				
				<select name="owner_id" id="owner_id" value="{{ old('owner_id') }}" class="form-control" required>
						<option value="">Please select</option>
			@foreach($owner as $owne)
			<option value="{{ $owne->user_code }}">
			{{ $owne->name }}
			</option>
			@endforeach
			  </select>
			</div>
          </div>
			
			
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('employee_id', 'Employee*', ['class' => 'control-label']) !!}
					<select name="employee_id" id="employee_id" value="{{ old('employee_id') }}" class="form-control" required>
						<option value="">Please select</option>
						@foreach($employees as $employee)
						<option value="{{ $employee->user_code }}"> {{ $employee->name }}</option>
						@endforeach
					</select>
                    <p class="help-block"></p>
                    @if($errors->has('employee_id'))
                        <p class="help-block">
                            {{ $errors->first('employee_id') }}
                        </p>
                    @endif
                </div>
            </div>
			
			
			
			<div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('type_of_meeting', 'Type of Meeting', ['class' => 'control-label']) !!}
				
				
				<select name="type_of_meeting" id="type_of_meeting" value="{{ old('type_of_meeting') }}" class="form-control" required>
						<option value="">Please select</option>
			@foreach($meeting as $meet)
			<option value="{{ $meet->name }}">
			{{ $meet->name }}
			</option>
			@endforeach
			  </select>
			</div>
          </div>
		  
		  
		  
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('meeting_date', 'Meeting Date*', ['class' => 'control-label']) !!}
                    {!! Form::text('meeting_date', old('meeting_date'), ['class' => 'form-control date', 'placeholder' => '', 'required' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('meeting_date'))
                        <p class="help-block">
                            {{ $errors->first('meeting_date') }}
                        </p>
                    @endif
                </div>
            </div>
			
			
			 <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('deadline', 'Deadline Date*', ['class' => 'control-label']) !!}
                    {!! Form::text('deadline', old('deadline'), ['class' => 'form-control date', 'placeholder' => '', 'required' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('deadline'))
                        <p class="help-block">
                            {{ $errors->first('deadline') }}
                        </p>
                    @endif
                </div>
            </div>
			
			
			
			 <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('review_date', 'Review Date*', ['class' => 'control-label']) !!}
                    {!! Form::text('review_date', old('review_date'), ['class' => 'form-control date', 'placeholder' => '', 'required' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('review_date'))
                        <p class="help-block">
                            {{ $errors->first('review_date') }}
                        </p>
                    @endif
                </div>
            </div>
			
			
			<div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('progress_status', 'Job Status', ['class' => 'control-label']) !!}
				
				
				<select name="progress_status" id="progress_status" value="{{ old('progress_status') }}" class="form-control" required>
						<option value="">Please select</option>
			@foreach($status as $stas)
			<option value="{{ $stas->name }}">
			{{ $stas->name }}
			</option>
			@endforeach
			  </select>
			</div>
          </div>
		  
		  
		  

		  
		  
		   <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('remarks', 'Remarks', ['class' => 'control-label']) !!}
				
				
				<textarea name="remarks" id="remarks"  class="form-control" >
				{{ old('remarks') }}
			  </textarea>
			</div>
          </div>
		  
		  
		  
		 <div class="row">
                <div class="col-xs-12 form-group"> 
			
				
				<input type="checkbox" name="reminder" id="reminder"   >
				Reminder
			
			 
			</div>
          </div>
		  
		  
		    <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('email', 'Reminder Email', ['class' => 'control-label']) !!}
				
				
				<input type="text"  name="email"  value="{{ old('email') }}" id="email"  class="form-control" >
				
			
			</div>
          </div>
		  
		  
		  <div class="row">
                <div class="col-xs-12 form-group"> 
				{!! Form::label('email_cc', 'Reminder CC', ['class' => 'control-label']) !!}
				
				
				<input type="text"  name="email_cc"  value="{{ old('email_cc') }}" id="email_cc"  class="form-control" >
				
			
			</div>
          </div>
			
			
			
			
	
            
        </div>
    </div>

    {!! Form::submit(trans('quickadmin.qa_save'), ['class' => 'btn btn-danger']) !!}
    {!! Form::close() !!}
@stop

@section('javascript')
    @parent
    <script>
        $('.date').datepicker({
            autoclose: true,
            dateFormat: "{{ config('app.date_format_js') }}"
        });
		$('.deadline').datepicker({
            autoclose: true,
            dateFormat: "{{ config('app.date_format_js') }}"
        });
		$('.review_date').datepicker({
            autoclose: true,
            dateFormat: "{{ config('app.date_format_js') }}"
        });
    </script>
    <script src="{{ url('quickadmin/js') }}/timepicker.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.4.5/jquery-ui-timepicker-addon.min.js"></script>
    <script src="https://cdn.datatables.net/select/1.2.0/js/dataTables.select.min.js"></script>    <script>
        $('.timepicker').datetimepicker({
            autoclose: true,
            timeFormat: "HH:mm:ss",
            timeOnly: true
        });
    </script>

@stop