@extends('layouts.app')

@section('content')
    <h3 class="page-title">{{$page_title}} </h3>
    @can('owner_create')
    <p>
        <a href="{{ route('admin.working_hours.create') }}" class="btn btn-success">@lang('quickadmin.qa_add_new')</a>
        
    </p>
    @endcan

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_list')
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped {{ count($appointments) > 0 ? 'datatable' : '' }} @can('working_hour_delete') dt-select @endcan">
                <thead>
                    <tr>
                        @can('working_hour_delete')
                            <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        @endcan

                        <th>Owner</th>
                        <th>Date</th>
                        <th>Start Time</th>
						<th>End Time</th>
                        <th>Status</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                
                <tbody>
                    @if (count($appointments) > 0)
                        @foreach ($appointments as $appoint)
                            <tr data-entry-id="{{ $appoint->id }}">
                                @can('owner_delete')
                                    <td></td>
                                @endcan

                                <td>{{ $appoint->owner_id}} </td>
                                <td>{{ $appoint->date }}</td>
                                
                                <td>{{ $appoint->start_time }}</td>
								<td>{{ $appoint->finish_time }}</td>
								<td>{{ $appoint->status }}</td>
                                <td>
                                    @can('working_hour_view')
                                    <a href="{{ route('admin.working_hours.show',[$appoint->id]) }}" class="btn btn-xs btn-primary">@lang('quickadmin.qa_view')</a>
                                    @endcan
                                    @can('working_hour_edit')
                                    <a href="{{ route('admin.working_hours.edit',[$appoint->id]) }}" class="btn btn-xs btn-info">@lang('quickadmin.qa_edit')</a>
                                    @endcan
                                    @can('working_hour_delete')
                                    {!! Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("quickadmin.qa_are_you_sure")."');",
                                        'route' => ['admin.working_hours.destroy', $appoint->id])) !!}
                                    {!! Form::submit(trans('quickadmin.qa_delete'), array('class' => 'btn btn-xs btn-danger')) !!}
                                    {!! Form::close() !!}
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="8">@lang('quickadmin.qa_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@stop

@section('javascript') 
    <script>
        @can('owner_delete')
            window.route_mass_crud_entries_destroy = '{{ route('admin.working_hours.mass_destroy') }}';
        @endcan

    </script>
@endsection