@extends('layouts.app')

@section('content')
    <h3 class="page-title">Owners</h3>
    
    {!! Form::model($owner, ['method' => 'PUT', 'route' => ['admin.owners.update', $owner->id]]) !!}

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_edit')
        </div>

        <div class="panel-body">
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('owner_code', 'Owner Code', ['class' => 'control-label']) !!}
                    {!! Form::text('owner_code', old('owner_code'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('owner_code'))
                        <p class="help-block">
                            {{ $errors->first('owner_code') }}
                        </p>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('owner_name', 'Owner Name', ['class' => 'control-label']) !!}
                    {!! Form::text('owner_name', old('owner_name'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('owner_name'))
                        <p class="help-block">
                            {{ $errors->first('owner_name') }}
                        </p>
                    @endif
                </div>
            </div>
      
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('owner_email', 'Owner Email', ['class' => 'control-label']) !!}
                    {!! Form::email('owner_email', old('owner_email'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('owner_email'))
                        <p class="help-block">
                            {{ $errors->first('owner_email') }}
                        </p>
                    @endif
                </div>
            </div>
            
        </div>
    </div>

    {!! Form::submit(trans('quickadmin.qa_update'), ['class' => 'btn btn-danger']) !!}
    {!! Form::close() !!}
@stop

