@extends('layouts.app')

@section('content')
    <h3 class="page-title">Company</h3>
    @can('company_create')
    <p>
        <a href="{{ route('admin.company.create') }}" class="btn btn-success">@lang('quickadmin.qa_add_new')</a>
        
    </p>
    @endcan

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_list')
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped {{ count($company) > 0 ? 'datatable' : '' }} @can('company_delete') dt-select @endcan">
                <thead>
                    <tr>
                        @can('company_delete')
                            <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        @endcan

                        <th>Company Code</th>
                        <th>Company Name</th>
                        <th>Reg No</th>
                       
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                
                <tbody>
                    @if (count($company) > 0)
                        @foreach ($company as $company)
                            <tr data-entry-id="{{ $company->id }}">
                                @can('company_delete')
                                    <td></td>
                                @endcan

                                <td>{{ $company->company_code}}</td>
                                <td>{{ $company->company_name }}</td>
                                
                                <td>{{ $company->regno }}</td>
                                <td>
                                    @can('company_view')
                                    <a href="{{ route('admin.company.show',[$company->id]) }}" class="btn btn-xs btn-primary">@lang('quickadmin.qa_view')</a>
                                    @endcan
                                    @can('company_edit')
                                    <a href="{{ route('admin.company.edit',[$company->id]) }}" class="btn btn-xs btn-info">@lang('quickadmin.qa_edit')</a>
                                    @endcan
                                    @can('company_delete')
                                    {!! Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("quickadmin.qa_are_you_sure")."');",
                                        'route' => ['admin.company.destroy', $company->id])) !!}
                                    {!! Form::submit(trans('quickadmin.qa_delete'), array('class' => 'btn btn-xs btn-danger')) !!}
                                    {!! Form::close() !!}
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="8">@lang('quickadmin.qa_no_entries_in_table')</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
@stop

@section('javascript') 
    <script>
        @can('company_delete')
            window.route_mass_crud_entries_destroy = '{{ route('admin.company.mass_destroy') }}';
        @endcan

    </script>
@endsection