@extends('layouts.app')

@section('content')
    <h3 class="page-title">Company</h3>
    {!! Form::open(['method' => 'POST', 'route' => ['admin.company.store']]) !!}

    <div class="panel panel-default">
        <div class="panel-heading">
            @lang('quickadmin.qa_create')
        </div>
        
        <div class="panel-body">
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('company_code', 'Company Code', ['class' => 'control-label']) !!}
                    {!! Form::text('company_code', old('company_code'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('company_code'))
                        <p class="help-block">
                            {{ $errors->first('company_code') }}
                        </p>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('company_name', 'Company Name', ['class' => 'control-label']) !!}
                    {!! Form::text('company_name', old('company_name'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('company_name'))
                        <p class="help-block">
                            {{ $errors->first('company_name') }}
                        </p>
                    @endif
                </div>
            </div>
        
            <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('regno', 'Register No', ['class' => 'control-label']) !!}
                    {!! Form::text('regno', old('regno'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('regno'))
                        <p class="help-block">
                            {{ $errors->first('regno') }}
                        </p>
                    @endif
                </div>
            </div>
			
			<div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('address1', 'Address1', ['class' => 'control-label']) !!}
                    {!! Form::text('address1', old('address1'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('address1'))
                        <p class="help-block">
                            {{ $errors->first('address1') }}
                        </p>
                    @endif
                </div>
            </div>
			
			<div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('address2', 'Address2', ['class' => 'control-label']) !!}
                    {!! Form::text('address2', old('address2'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('address2'))
                        <p class="help-block">
                            {{ $errors->first('address2') }}
                         </p>
                    @endif
                </div>
		  </div>
            
			
		 <div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('postcode', 'Postcode', ['class' => 'control-label']) !!}
                    {!! Form::text('postcode', old('postcode'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('postcode'))
                        <p class="help-block">
                            {{ $errors->first('postcode') }}
                        </p>
                    @endif
                </div>
		</div>	
		
		<div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('city', 'City', ['class' => 'control-label']) !!}
                    {!! Form::text('city', old('city'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('city'))
                        <p class="help-block">
                            {{ $errors->first('city') }}
                        </p>
                    @endif
                </div>
		</div>
		
		
		<div class="row">
                <div class="col-xs-12 form-group">
                    {!! Form::label('state', 'State', ['class' => 'control-label']) !!}
                    {!! Form::text('state', old('state'), ['class' => 'form-control', 'placeholder' => '']) !!}
                    <p class="help-block"></p>
                    @if($errors->has('state'))
                        <p class="help-block">
                            {{ $errors->first('state') }}
                        </p>
                    @endif
                </div>
		</div>
		
			
			
        </div>
    </div>

    {!! Form::submit(trans('quickadmin.qa_save'), ['class' => 'btn btn-danger']) !!}
    {!! Form::close() !!}
@stop

