<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use DateTime;
use DateInterval;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
		
		$user = \Auth::user();
			
        $role_id=$user->role_id;
		$user_code=$user->user_code;
		
		
		
		$today_date=date('Y-m-d');
		
		$today_meet_total = DB::table('working_hours')
		            ->select(['id'])
                    ->where('date', $today_date)
					
                    ->count();
		$today_meet_completed = DB::table('working_hours')
		            ->select(['id'])
                    ->where('date', $today_date)
					->where('status', 'Completed')
					
                    ->count();	

					
        $today_task_total_sql = DB::table('task_manager')
		            ->select(['id'])
                    ->where('meeting_date', $today_date);
					
				if($role_id==2)
					{
						$today_task_total_sql=$today_task_total_sql->where('owner_id', $user_code);
					}
                else if($role_id==3)
					{
						$today_task_total_sql=$today_task_total_sql->where('employee_id', $user_code);
					}  					
				
               $today_task_total=$today_task_total_sql->count();
					
					
				$today_task_completed_sql = DB::table('task_manager')
		            ->select(['id'])
                    ->where('meeting_date', $today_date)
					->where('progress_status', 'Completed');
				
                 if($role_id==2)
					{
						$today_task_completed_sql=$today_task_completed_sql->where('owner_id', $user_code);
					}
                else if($role_id==3)
					{
						$today_task_completed_sql=$today_task_completed_sql->where('employee_id', $user_code);
					}  					
					
                $today_task_completed=$today_task_completed_sql->count();	
       /* Carbon::setWeekStartsAt(Carbon::SUNDAY);
        Carbon::setWeekEndsAt(Carbon::SATURDAY);
*/		
	    $now = Carbon::now();
			
	   $weekStartDate = $now->startOfWeek()->format('Y-m-d');
	 
       $weekEndDate = $now->endOfWeek()->format('Y-m-d');
		
		
		$week_task_total_sql = DB::table('task_manager')
		            ->select(['id'])
                    ->whereBetween('meeting_date', [$weekStartDate, $weekEndDate]);
					
					
		 if($role_id==2)
					{
						$week_task_total_sql=$week_task_total_sql->where('owner_id', $user_code);
					}
        else if($role_id==3)
					{
						$week_task_total_sql=$week_task_total_sql->where('employee_id', $user_code);
					}  	

					
		$week_task_total=$week_task_total_sql->count();			
                   
		$week_task_completed_sql = DB::table('task_manager')
		            ->select(['id'])
                    ->whereBetween('meeting_date', [$weekStartDate, $weekEndDate])
					->where('progress_status', 'Completed');
					
		if($role_id==2)
					{
						$week_task_completed_sql=$week_task_completed_sql->where('owner_id', $user_code);
					}
        else if($role_id==3)
					{
						$week_task_completed_sql=$week_task_completed_sql->where('employee_id', $user_code);
					}  	
			
					
        $week_task_completed=$week_task_completed_sql->count();	
		
		
		
		
		
		
		
		
		
		$currentweek_meet_total = DB::table('working_hours')
		            ->select(['id'])
                    ->whereBetween('date', [$weekStartDate, $weekEndDate])
					
                    ->count();
					
					
					
		$currentweekDate = new DateTime($weekStartDate);
 
	
		$laskweekDate = $currentweekDate->sub(new DateInterval('P7D'));
		 
		
		$lastweek_start = $laskweekDate->format('Y-m-d');
		
		
		$currentweekendDate = new DateTime($weekEndDate);
 
	
		$laskweekendDate = $currentweekendDate->sub(new DateInterval('P7D'));
		 
		
		$lastweek_end = $laskweekendDate->format('Y-m-d');
		
		
		$lastweek_meet_total = DB::table('working_hours')
		            ->select(['id'])
                    ->whereBetween('date', [$lastweek_start, $lastweek_end])
					
                    ->count();
		
		
		
        //return view('home');
		        return view('home', compact('today_meet_total','today_meet_completed','today_task_total','today_task_completed',
				'week_task_total','week_task_completed',
				'currentweek_meet_total','lastweek_meet_total','role_id') );

    }
}
