<?php

namespace App\Http\Controllers\Admin;

use App\Taskmanager;
use App\Appointment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StoreTaskmanagerRequest;
use App\Http\Requests\Admin\UpdateTaskmanagerRequest;


use App\User;

use Excel;

use DB;

class TaskmanagerController extends Controller
{
    /**
     * Display a listing of Appointment.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (! Gate::allows('taskmanager_access')) {
            return abort(401);
        }
		

		$user = \Auth::user();
		if($user->role_id==1)
        {	
		$taskmanager = DB::table('task_manager as t' )
            ->select('t.company_id', 'u.name as employee_id', 't.meeting_date','t.id')
            ->join('users as u', 'u.user_code', '=', 't.employee_id')
           // ->where('u.user_code', '=', $user->user_code)

            ->get();
		}
		else if($user->role_id ==2)
        {	
	
	    
			$taskmanager = DB::table('task_manager as t' )
            ->select('t.company_id', 'u.name as employee_id', 't.meeting_date','t.id')
            ->join('users as u', 'u.user_code', '=', 't.owner_id')
            ->where('u.user_code', '=', $user->user_code)

            ->get();
			
	
		
		}
		
		else if($user->role_id ==3)
        {	
	
	    
		$taskmanager = DB::table('task_manager as t' )
            ->select('t.company_id', 'u.name as employee_id', 't.meeting_date','t.id')
            ->join('users as u', 'u.user_code', '=', 't.employee_id')
            ->where('u.user_code', '=', $user->user_code)

            ->get();
	
	
		}
		
	
		
			
       // $taskmanager = Taskmanager::all();

        return view('admin.taskmanager.index', compact('taskmanager'));
    }

    /**
     * Show the form for creating new Appointment.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (! Gate::allows('taskmanager_create')) {
            return abort(401);
        }
		
		$results=\App\User::where('role_id',2)->get();
		
		
		
		
        $relations = [
		   // 'owner' => \App\Owner::get(),
		   
		    'owner' => \App\User::where('role_id',2)->get(),
		    'company' => \App\Company::get(),
		    'segments' => \App\Segment::get(),
            'status' => \App\Status::get(),
            'employees' => \App\User::where('role_id',3)->get(),
			'meeting' => \App\Meeting::get(),
        ];
    
        //return view('admin.taskmanager.create', compact('segments') +$relations);
		
		return view('admin.taskmanager.create', $relations);
		
		
    }

    /**
     * Store a newly created Appointment in storage.
     *
     * @param  \App\Http\Requests\StoreAppointmentsRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreTaskmanagerRequest $request)
    {
        if (! Gate::allows('taskmanager_create')) {
            return abort(401);
        }
		
		
		/*
		$employee = \App\Employee::find($request->employee_id);
		$working_hours = \App\WorkingHour::where('employee_id', $request->employee_id)->whereDay('date', '=', date("d", strtotime($request->date)))->whereTime('start_time', '<=', date("H:i", strtotime("".$request->starting_hour.":".$request->starting_minute.":00")))->whereTime('finish_time', '>=', date("H:i", strtotime("".$request->finish_hour.":".$request->finish_minute.":00")))->get();
		if(!$employee->provides_service($request->service_id)) return redirect()->back()->withErrors("This employee doesn't provide your selected service")->withInput();
        if($working_hours->isEmpty()) return redirect()->back()->withErrors("This employee isn't working at your selected time")->withInput();
		*/
		
		$taskmanager = new Taskmanager;
		$taskmanager->company_id = $request->company_id;
		$taskmanager->item = $request->item;
		$taskmanager->segment_id = $request->segment_id;
		
		$taskmanager->owner_id = $request->owner_id;
		$taskmanager->employee_id = $request->employee_id;
		$taskmanager->type_of_meeting = $request->type_of_meeting;
		
		$taskmanager->meeting_date = $request->meeting_date;
		$taskmanager->deadline = $request->deadline;
		$taskmanager->review_date = $request->review_date;
		
		$taskmanager->progress_status = $request->progress_status;
		$taskmanager->remarks = $request->remarks;
		$taskmanager->reminder = $request->reminder;
		
		$taskmanager->email = $request->email;
		$taskmanager->email_cc = $request->email_cc;
		
		
		
		$taskmanager->save();
		
		$task_id=$taskmanager->id;
		
		$tasks = Taskmanager::findOrFail($task_id);

		
		//$user = User::findOrFail($id);
		
		$employee =User::where('user_code', '=', $request->employee_id)->get();
		
		
		
		
		
		 $to = "robingnanaraj1986@gmail.com, sigamanimy@yahoo.com,". $employee[0]->email ;
			$subject = "Assigned New Task";

			$message = "
			<html>
			<head>
			<title>Assigned New Task</title>
			</head>
			<body>
			<p>Hi ".$employee[0]->name."</p>
			<p></p>
			
			<p>You have received new task , please check task management tool</p>
			
			<p></p>
			<table>
			<tr>
			<td>Company Name</td>
			<td>".$tasks->company_id."</td>
			</tr>
			
			<tr>
			<td>Item</td>
			<td>".$tasks->item."</td>
			</tr>
			
			<tr>
			<td>Segment</td>
			<td>".$tasks->segment_id."</td>
			</tr>
			
			<tr>
			<td>Meeting</td>
			<td>".$tasks->type_of_meeting."</td>
			</tr>
			<tr>
			<td>Meeting Date</td>
			<td>".$tasks->meeting_date."</td>
			</tr>
			
			<tr>
			<td>Review Date</td>
			<td>".$tasks->review_date."</td>
			</tr>
			
			<tr>
			<td>Deadline</td>
			<td>".$tasks->deadline."</td>
			</tr>
			
			</table>
			<p></p>
			
			<p>Thanks <br> Task Management</p>
			
			</body>
			</html>
			";

			// Always set content-type when sending HTML email
			$headers = "MIME-Version: 1.0" . "\r\n";
			$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

			// More headers
			$headers .= 'From: <robin@visoft.com.my>' . "\r\n";
			//$headers .= 'Cc: myboss@example.com' . "\r\n";

			
			mail($to,$subject,$message,$headers);
		



        return redirect()->route('admin.taskmanager.index');
    }


    /**
     * Show the form for editing Appointment.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('taskmanager_edit')) {
            return abort(401);
        }
      /*  $relations = [
            'clients' => \App\Client::get()->pluck('first_name', 'id')->prepend('Please select', ''),
            'employees' => \App\Employee::get()->pluck('first_name', 'id')->prepend('Please select', ''),
        ];*/
		
		
		
		
		        $relations = [
		   // 'owner' => \App\Owner::get()->pluck('owner_name','owner_name')->prepend('Please select', ''),
		   'owner' => \App\User::where('role_id',2)->get()->pluck('name','user_code')->prepend('Please select', ''),
		    'company' => \App\Company::get()->pluck('company_name', 'company_name')->prepend('Please select', ''),
		    'segments' => \App\Segment::get()->pluck('segment_name', 'segment_name')->prepend('Please select', ''),
            'status' => \App\Status::get()->pluck('name', 'name')->prepend('Please select', ''),
            'employees' => \App\User::where('role_id',3)->get()->pluck('name','user_code')->prepend('Please select', ''),
			'meeting' => \App\Meeting::get()->pluck('name', 'name')->prepend('Please select', ''),
        ];
		
		

        $taskmanager = Taskmanager::findOrFail($id);
		
		
        $task_history = DB::table('task_history')
                    ->where('task_id', $id)
                    ->get();
			

        return view('admin.taskmanager.edit', compact('taskmanager','task_history') + $relations);
    }

    /**
     * Update Appointment in storage.
     *
     * @param  \App\Http\Requests\UpdateAppointmentsRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateTaskmanagerRequest $request, $id)
    {
        if (! Gate::allows('taskmanager_edit')) {
            return abort(401);
        }
		//$taskmanager = new Taskmanager;
		// progress_status  remarks
		
		
        $taskmanager = Taskmanager::findOrFail($id);
		$tasks = $taskmanager;
		
		
		$new_deadline=$request->deadline;
		$new_progress_status = $request->progress_status;
		$new_remarks = $request->remarks;
		
		$deadline=$taskmanager->deadline;
		
		$progress_status=$taskmanager->progress_status;
		
		$remarks=$taskmanager->remarks;
		
		
		if($new_deadline !=$deadline)
		{	
		
		
		 $task_history_deadline = DB::table('task_history')->insert(
                    [
					   'company_id'=>$taskmanager->company_id,
					   'emp_id'=>$taskmanager->employee_id,
					   'task_id'=>$id,
					   'change_type' => 'deadline',
                        'change_value' => $deadline,
						'created_on'=> date('Y-m-d H:i:s')]
            );
		}
		
		if($new_progress_status !=$progress_status)
		{	
		
		
		 $task_history_status = DB::table('task_history')->insert(
                    [
					   'company_id'=>$taskmanager->company_id,
					   'emp_id'=>$taskmanager->employee_id,
					   'task_id'=>$id,
					   'change_type' => 'progress_status',
                        'change_value' => $progress_status,
						'created_on'=> date('Y-m-d H:i:s')]
            );
		}
		
		
		if($new_remarks !=$remarks)
		{	
		
		
		 $task_history_remarks = DB::table('task_history')->insert(
                    [
					   'company_id'=>$taskmanager->company_id,
					   'emp_id'=>$taskmanager->employee_id,
					   'task_id'=>$id,
					   'change_type' => 'remarks',
                        'change_value' => $remarks,
						'created_on'=> date('Y-m-d H:i:s')]
            );
		}
		
		
		$taskmanager->update($request->all());
		
        
		
		
		
		//$task_id=$taskmanager->id;
		
		if($new_progress_status =='Completed')
		{	
		
		

		
		//$user = User::findOrFail($id);
		
		$employee =User::where('user_code', '=', $tasks->owner_id)->get();
		
		
		
		
		
		 $to = "robingnanaraj1986@gmail.com, sigamanimy@yahoo.com,". $employee[0]->email ;
			$subject = "Completed The Task";

			$message = "
			<html>
			<head>
			<title>Assigned New Task</title>
			</head>
			<body>
			<p>Hi ".$employee[0]->name."</p>
			<p></p>
			
			<p>You have received completed task , please check task management tool</p>
			
			<p></p>
			<table>
			<tr>
			<td>Company Name</td>
			<td>".$tasks->company_id."</td>
			</tr>
			
			<tr>
			<td>Item</td>
			<td>".$tasks->item."</td>
			</tr>
			
			<tr>
			<td>Employee</td>
			<td>".$tasks->employee_id."</td>
			</tr>
			
			<tr>
			<td>Segment</td>
			<td>".$tasks->segment_id."</td>
			</tr>
			
			<tr>
			<td>Meeting</td>
			<td>".$tasks->type_of_meeting."</td>
			</tr>
			<tr>
			<td>Meeting Date</td>
			<td>".$tasks->meeting_date."</td>
			</tr>
			
			<tr>
			<td>Review Date</td>
			<td>".$tasks->review_date."</td>
			</tr>
			
			<tr>
			<td>Deadline</td>
			<td>".$tasks->deadline."</td>
			</tr>
			
			</table>
			<p></p>
			
			<p>Thanks <br> Task Management</p>
			
			</body>
			</html>
			";

			// Always set content-type when sending HTML email
			$headers = "MIME-Version: 1.0" . "\r\n";
			$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

			// More headers
			$headers .= 'From: <robin@visoft.com.my>' . "\r\n";
			//$headers .= 'Cc: myboss@example.com' . "\r\n";

			
			mail($to,$subject,$message,$headers);
      
		}

        return redirect()->route('admin.taskmanager.index');
    }
	
	
	
	
	
		public function excel()
	{
		
		$file = $request->file('contacts_csv');
                $imported_data = Excel::load($file->getRealPath())
                                ->noHeading()
                                ->skipRows(1)
                                ->get()
                                ->toArray();
		Excel::load($file->getRealPath(), function($reader) {

		//DB::table('excel_sheet')->where()->delete();

	
		DB::table('excel_sheet')->delete();
		
		
		$reader->each(function($sheet) {

        $sheet_title = $sheet->getTitle();
   
        foreach($sheet as $row)
		 {
		
		
		 $sheet_value = json_encode($row);
		 print_r($sheet_value);
		 echo "<br>";
		 
		/*    $purchase = DB::table('excel_sheet')->insert(
                                    ['sheet_name' => $sheet_title,
                                    'sheet_data' => $sheet_value]
                                  );
								  
					  */
		


        }

        });



		});


		// return view('contact.ecel')
          //  ->with(compact('data'));
	}

	
		public function task_import()
	{
		
		if (! Gate::allows('taskmanager_access')) {
            return abort(401);
        }

        $appointments = Appointment::all();

        return view('admin.appointments.task', compact('appointments'));
	}
	
	
	public function statusdetails()
	{
		echo "123444";
		exit;
	}
	
	
   public function show($id)
    {
		
		
		  if (! Gate::allows('taskmanager_view')) {
            return abort(401);
        }
		$taskmanager = Taskmanager::findOrFail($id);
		return view('admin.taskmanager.show', compact('taskmanager') );
	}

 
    public function destroy($id)
    {
        if (! Gate::allows('taskmanager_delete')) {
            return abort(401);
        }
        $appointment = Taskmanager::findOrFail($id);
        $appointment->delete();

        return redirect()->route('admin.taskmanager.index');
    }

  public function massDestroy(Request $request)
    {
        if (! Gate::allows('taskmanager_delete')) {
            return abort(401);
        }
        if ($request->input('ids')) {
            $entries = Taskmanager::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
	


}
