<?php

namespace App\Http\Controllers\Admin;

use App\Taskmanager;
use App\Appointment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StoreTask_importRequest;
use App\Http\Requests\Admin\UpdateTaskmanagerRequest;

use Excel;

use DB;

class Task_importController extends Controller
{
    /**
     * Display a listing of Appointment.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (! Gate::allows('appointment_access')) {
            return abort(401);
        }

        $taskmanager = Taskmanager::all();

        return view('admin.taskmanager.import', compact('taskmanager'));
    }

    /**
     * Show the form for creating new Appointment.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (! Gate::allows('appointment_create')) {
            return abort(401);
        }
		
		
		
		
        $relations = [
		    'owner' => \App\Owner::get(),
		    'company' => \App\Company::get(),
		    'segments' => \App\Segment::get(),
            'status' => \App\Status::get(),
            'employees' => \App\Employee::get(),
			'meeting' => \App\Meeting::get(),
        ];
    
        //return view('admin.taskmanager.create', compact('segments') +$relations);
		
		return view('admin.taskmanager.create', $relations);
		
		
    }

    /**
     * Store a newly created Appointment in storage.
     *
     * @param  \App\Http\Requests\StoreAppointmentsRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function import(StoreTask_importRequest $request)
    {
        if (! Gate::allows('appointment_create')) {
            return abort(401);
        }
		
	   
		//$file = $request->file('files');
	
	//	$file = $request->file('files');
		
		 $file = $request->file('files');
                $imported_data = Excel::load($file->getRealPath())
                                ->noHeading()
                               ->skipRows(1)
                                ->get()
                                ->toArray();
								
								
		 		 
                //$business_id = $request->session()->get('user.business_id');
                //$user_id = $request->session()->get('user.id');

                $formated_data = [];

                
                
              //  DB::beginTransaction();
                foreach ($imported_data as $value) {
				
				   $taskmanager = new Taskmanager;
				  $taskmanager->company_id = $value[1];
					$taskmanager->item = $value[2];
					$taskmanager->segment_id = $value[3];
					
					$taskmanager->owner_id = $value[4];
					$taskmanager->employee_id = $value[5];
					$taskmanager->type_of_meeting = $value[6];
					
					$taskmanager->meeting_date = date('Y-m-d',strtotime($value[7]));
					$taskmanager->deadline = date('Y-m-d',strtotime($value[8]));
					$taskmanager->review_date = date('Y-m-d',strtotime($value[9]));
					
					$taskmanager->progress_status = $value[10];
					$taskmanager->remarks = $value[11];
					
					
					
					
					$taskmanager->save();
					
				}
			
        
        return redirect()->route('admin.taskmanager.index');
    }


    /**
     * Show the form for editing Appointment.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('appointment_edit')) {
            return abort(401);
        }
      /*  $relations = [
            'clients' => \App\Client::get()->pluck('first_name', 'id')->prepend('Please select', ''),
            'employees' => \App\Employee::get()->pluck('first_name', 'id')->prepend('Please select', ''),
        ];*/
		
		        $relations = [
		    'owner' => \App\Owner::get()->pluck('owner_name','owner_name')->prepend('Please select', ''),
		    'company' => \App\Company::get()->pluck('company_name', 'company_name')->prepend('Please select', ''),
		    'segments' => \App\Segment::get()->pluck('segment_name', 'segment_name')->prepend('Please select', ''),
            'status' => \App\Status::get()->pluck('name', 'name')->prepend('Please select', ''),
            'employees' => \App\Employee::get()->pluck('first_name', 'first_name')->prepend('Please select', ''),
			'meeting' => \App\Meeting::get()->pluck('name', 'name')->prepend('Please select', ''),
        ];
		
		

        $taskmanager = Taskmanager::findOrFail($id);

        return view('admin.taskmanager.edit', compact('taskmanager') + $relations);
    }
	
	    public function destroy($id)
    {
		
		
        if (! Gate::allows('taskmanager_approve')) {
            return abort(401);
        }
		
		    DB::table('task_manager')
                            ->where('id', $id)
                            
                            ->update(['approved' => 1]);
							
        
            
			
			            return redirect('/admin/task/reports');
        //return redirect()->route('admin.task.reports');
    }

    /**
     * Update Appointment in storage.
     *
     * @param  \App\Http\Requests\UpdateAppointmentsRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateTaskmanagerRequest $request, $id)
    {
        if (! Gate::allows('appointment_edit')) {
            return abort(401);
        }
		//$taskmanager = new Taskmanager;
        $taskmanager = Taskmanager::findOrFail($id);
		
        $taskmanager->update($request->all());



        return redirect()->route('admin.taskmanager.index');
    }
	
	
	
	
		public function excel()
	{
		
		$file = $request->file('contacts_csv');
                $imported_data = Excel::load($file->getRealPath())
                                ->noHeading()
                                ->skipRows(1)
                                ->get()
                                ->toArray();
		Excel::load($file->getRealPath(), function($reader) {

		//DB::table('excel_sheet')->where()->delete();

	
		DB::table('excel_sheet')->delete();
		
		
		$reader->each(function($sheet) {

        $sheet_title = $sheet->getTitle();
   
        foreach($sheet as $row)
		 {
		
		
		 $sheet_value = json_encode($row);
		 print_r($sheet_value);
		 echo "<br>";
		 
		/*    $purchase = DB::table('excel_sheet')->insert(
                                    ['sheet_name' => $sheet_title,
                                    'sheet_data' => $sheet_value]
                                  );
								  
					  */
		


        }

        });



		});


		// return view('contact.ecel')
          //  ->with(compact('data'));
	}

	
		public function task_import()
	{
		
		if (! Gate::allows('appointment_access')) {
            return abort(401);
        }

        $appointments = Appointment::all();

        return view('admin.appointments.task', compact('appointments'));
	}
	
	
   public function show($id)
    {
		echo "ddddddddddddd";
	}
	
    /**
     * Display Appointment.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
   /* public function show($id)
    {
        if (! Gate::allows('appointment_view')) {
            return abort(401);
        }
        $relations = [
            'clients' => \App\Client::get()->pluck('first_name', 'id')->prepend('Please select', ''),
            'employees' => \App\Employee::get()->pluck('first_name', 'id')->prepend('Please select', ''),
        ];

        $appointment = Appointment::findOrFail($id);

        return view('admin.appointments.show', compact('appointment') + $relations);
    }
    */

    /**
     * Remove Appointment from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
	 
	 /*
    public function destroy($id)
    {
        if (! Gate::allows('appointment_delete')) {
            return abort(401);
        }
        $appointment = Appointment::findOrFail($id);
        $appointment->delete();

        return redirect()->route('admin.appointments.index');
    }
	*/

    /**
     * Delete all selected Appointment at once.
     *
     * @param Request $request
     */
  
/*
  public function massDestroy(Request $request)
    {
        if (! Gate::allows('appointment_delete')) {
            return abort(401);
        }
        if ($request->input('ids')) {
            $entries = Appointment::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
	*/


}
